// Elements.cpp : plik implementacji
//

#include "stdafx.h"
#include "Sketcher.h"
#include "Elements.h"
#include "OurConstants.h"
#include <math.h>

IMPLEMENT_SERIAL(CElement, CObject, VERSION_NUMBER)
IMPLEMENT_SERIAL(CLine, CElement, VERSION_NUMBER)
IMPLEMENT_SERIAL(CRectangle, CElement, VERSION_NUMBER)
IMPLEMENT_SERIAL(CCircle, CElement, VERSION_NUMBER)
IMPLEMENT_SERIAL(CCurve, CElement, VERSION_NUMBER)
IMPLEMENT_SERIAL(CText, CElement, VERSION_NUMBER)

// CElement
CElement::CElement()
{
}

CElement::~CElement()
{
}

// Oblicza prostokt ograniczajcy element
CRect CElement::GetBoundRect()
{
   CRect BoundingRect;                 // Obiekt do przechowania prostokta ograniczajcego
   BoundingRect = m_EnclosingRect;     // Zapisz prostokt opsiujcy

   // Powiksz prostokt o szeoko pira
   int Offset = m_Pen == 0? 1:m_Pen;   // Szeroko musi wynosi przynajmniej 1
   BoundingRect.InflateRect(Offset, Offset);
   return BoundingRect;                // Zwr prostokt ograniczajcy
}

void CElement::Serialize(CArchive& ar)
{
  CObject::Serialize(ar);              // Wywoaj funkcj klasy bazowej.

  if (ar.IsStoring())
   {
     ar << m_Color                     // Zapisz kolor,
        << m_EnclosingRect             // i prostokt opsiujcy,
        << m_Pen;                      // i szeroko pira
  }
  else
  {
    ar >> m_Color                      // Odczytaj biecy kolor
       >> m_EnclosingRect              // i prostokt opsiujcy,
       >> m_Pen;                       // i szeroko pira
  }
}

// End Funkcje skadowe CElement

// CLine
CLine::CLine(void)
{
}

CLine::~CLine(void)
{
}

// Konstruktor klasy CLine
CLine::CLine(CPoint Start, CPoint End, COLORREF aColor, int PenWidth)
{
   m_StartPoint = Start;               // Ustawia punkt poczkowy linii
   m_EndPoint = End;                   // Ustawia punkt kocowy linii
   m_Color = aColor;                   // Ustawia kolor linii
   m_Pen = PenWidth;                   // Ustawia szeroko pira

   // Definiuje prostokt opisujcy
   m_EnclosingRect = CRect(Start, End);
   m_EnclosingRect.NormalizeRect();
}

// Rysuj obiekt CLine
void CLine::Draw(CDC* pDC, CElement* pElement)
{
   // Tworzy piro dla tego obiektu i
   // inicjalizuje je z obiektem koloru i lini o gruboci 1 piksela
   CPen aPen;
   COLORREF aColor = m_Color;             // Inicjalizacja z kolorem elementu.
   if(this == pElement)                   // Czy ten element jest wybrany?
      aColor = SELECT_COLOR;              // Ustaw kolor wyrnienia.
   if(!aPen.CreatePen(PS_SOLID, m_Pen, aColor))
   {
      // Tworzenie pira nie powiodo si.
      AfxMessageBox(_T("Tworzenie pira nie powiodo si. drawing a line"), MB_OK);
      AfxAbort();
   }

   CPen* pOldPen = pDC->SelectObject(&aPen);  // Wybierz piro

   // Teraz rysuj lini
   pDC->MoveTo(m_StartPoint);
   pDC->LineTo(m_EndPoint);

   pDC->SelectObject(pOldPen);                // Przywr stare piro
}

void CLine::Move(CSize& aSize)
{
  m_StartPoint += aSize;               // Przenie punkt pocztkowy
  m_EndPoint += aSize;                 // i punkt kocowy.
  m_EnclosingRect += aSize;            // Przenie prostokt opisujcy
}

void CLine::Serialize(CArchive& ar)
{
  CElement::Serialize(ar);             // Wywoaj funkcj klasy bazowej.

  if (ar.IsStoring())
  {
    ar << m_StartPoint                 // Zapisz punkt pocztkowy linii,
       << m_EndPoint;                  // i punkt kocowy.
  }
  else
  {
    ar >> m_StartPoint                 // Pobierz punkt pocztkowy linii,
       >> m_EndPoint;                  // i punkt kocowy.
  }
}

// CRectangle

CRectangle::CRectangle(void)
{
}

CRectangle::~CRectangle(void)
{
}

// Konstruktor klasy CRectangle
CRectangle:: CRectangle(CPoint Start, CPoint End, COLORREF aColor, int PenWidth)
{
   m_Color = aColor;          // Ustaw kolor prostokta
   m_Pen = PenWidth;                   // Ustawia szeroko pira

   // Definiuje prostokt opisujcy 
   m_EnclosingRect = CRect(Start, End);
   m_EnclosingRect.NormalizeRect();
}

// Rysuj obiekt CRectangle
void CRectangle::Draw(CDC* pDC, CElement* pElement)
{
   // Tworzy piro dla tego obiektu i
   // inicjalizuje je z obiektem koloru i lini o gruboci 1 piksela
   CPen aPen;
   COLORREF aColor = m_Color;             // Inicjalizacja z kolorem elementu.
   if(this == pElement)                   // Czy ten element jest wybrany?
      aColor = SELECT_COLOR;              // Ustaw kolor wyrnienia.
   if(!aPen.CreatePen(PS_SOLID, m_Pen, aColor))
   {
      // Tworzenie pira nie powiodo si.
      AfxMessageBox(_T("Tworzenie pira nie powiodo si. drawing a rectangle"), MB_OK);
      AfxAbort();
   }

   // Wybierz piro
   CPen* pOldPen = pDC->SelectObject(&aPen);
   // Select the brush
   CBrush* pOldBrush = (CBrush*)pDC->SelectStockObject(NULL_BRUSH);

   // Teraz rysuj prostokt
   pDC->Rectangle(m_EnclosingRect);

   pDC->SelectObject(pOldBrush);       // Przywr stary pdzel
   pDC->SelectObject(pOldPen);         // Przywr stare piro
}

void CRectangle::Move(CSize& aSize)
{
  m_EnclosingRect+= aSize;             // Przenie prostokt
}

void CRectangle::Serialize(CArchive& ar)
{
  CElement::Serialize(ar);             // Wywoaj funkcj klasy bazowej.
}

// CCircle

CCircle::CCircle(void)
{
}

CCircle::~CCircle(void)
{
}

// Konstruktor obiektu okrgu
CCircle::CCircle(CPoint Start, CPoint End, COLORREF aColor, int PenWidth)
{
   // Najpierw oblicz promie.
   // Uywamy typu zmiennoprzecinkowego, poniewa jest to wymagane
   // przez funkcj biblioteczn (w math.h) dla obliczenia pierwiastka
   long Radius = static_cast<long> (sqrt(
                  static_cast<double>((End.x-Start.x)*(End.x-Start.x)+
                                      (End.y-Start.y)*(End.y-Start.y))));

   // Teraz oblicz prostokt opisujcy okrg
   // przy zaoeniu trybu mapowania MM_TEXT
   m_EnclosingRect = CRect(Start.x-Radius, Start.y-Radius,
                           Start.x+Radius, Start.y+Radius);

   m_Color = aColor;                   // Ustaw kolor okrgu.
   m_Pen = PenWidth;                   // Ustawia szeroko pira
}

// Draw a circle
void CCircle::Draw(CDC* pDC, CElement* pElement)
{
   // Tworzy piro dla tego obiektu i
   // inicjalizuje je z obiektem koloru i lini o gruboci 1 piksela
   CPen aPen;
   COLORREF aColor = m_Color;             // Inicjalizacja z kolorem elementu.
   if(this == pElement)                   // Czy ten element jest wybrany?
      aColor = SELECT_COLOR;              // Ustaw kolor wyrnienia.
   if(!aPen.CreatePen(PS_SOLID, m_Pen, aColor))
   {
      // Tworzenie pira nie powiodo si.
      AfxMessageBox(_T("Tworzenie pira nie powiodo si. drawing a circle"), MB_OK);
      AfxAbort();
   }

   CPen* pOldPen = pDC->SelectObject(&aPen);  // Wybierz piro

   // Wybierz pusty pdzel
   CBrush* pOldBrush = (CBrush*)pDC->SelectStockObject(NULL_BRUSH);

   // Teraz rysuj okrg
   pDC->Ellipse(m_EnclosingRect);

   pDC->SelectObject(pOldPen);                // Przywr stare piro
   pDC->SelectObject(pOldBrush);              // Przywr stary pdzel
}

void CCircle::Move(CSize& aSize)
{
  m_EnclosingRect+= aSize;             // Przenie prostokt definiujcy okrg
}

void CCircle::Serialize(CArchive& ar)
{
  CElement::Serialize(ar);             // Wywoaj funkcj klasy bazowej.
}

// CCurve

CCurve::CCurve(void)
{
}

CCurve::~CCurve(void)
{
}

// Konstruktor obiektu krzywej
CCurve::CCurve(CPoint FirstPoint,CPoint SecondPoint, COLORREF aColor, int PenWidth)
{
   m_PointList.AddTail(FirstPoint);    // Dodaj pierwszy punkt do listy
   m_PointList.AddTail(SecondPoint);   // Dodaj drugi punkt do listy
   m_Color = aColor;                   // Zapisz kolor
   m_Pen = PenWidth;                   // Ustawia szeroko pira

   // Konstruuj prostokt opisujcy, zakadajc tryb MM_TEXT
   m_EnclosingRect = CRect(FirstPoint, SecondPoint);
   m_EnclosingRect.NormalizeRect();
}

void CCurve::AddSegment(CPoint& aPoint)
{
   m_PointList.AddTail(aPoint);                // Dodaj punkt na kocu.

   // Modyfikuj prostokt opisujcy dla nowego punktu
   m_EnclosingRect = CRect(min(aPoint.x, m_EnclosingRect.left),
                           min(aPoint.y, m_EnclosingRect.top),
                           max(aPoint.x, m_EnclosingRect.right),
                           max(aPoint.y, m_EnclosingRect.bottom));
}

// Rysuj krzyw
void CCurve::Draw(CDC* pDC, CElement* pElement)
{
   // Tworzy piro dla tego obiektu i
   // inicjalizuje je z obiektem koloru i lini o gruboci 1 piksela
   CPen aPen;
   COLORREF aColor = m_Color;             // Inicjalizacja z kolorem elementu.
   if(this == pElement)                   // Czy ten element jest wybrany?
      aColor = SELECT_COLOR;              // Ustaw kolor wyrnienia.
   if(!aPen.CreatePen(PS_SOLID, m_Pen, aColor))
   {
      // Tworzenie pira nie powiodo si.. Zamknij program
      AfxMessageBox(_T("Tworzenie pira nie powiodo si. drawing a curve"), MB_OK);
      AfxAbort();
   }

   CPen* pOldPen = pDC->SelectObject(&aPen);  // Wybierz piro

   // Now draw the curve
   // Pobierz pozycj na licie pierwszego elementu
   POSITION aPosition = m_PointList.GetHeadPosition();

   // Jeeli jest poprawna, przejd do tego punktu
   if(aPosition)
      pDC->MoveTo(m_PointList.GetNext(aPosition));

   // Rysuj odcinek dla wszystkich poniszych punktw
   while(aPosition)
      pDC->LineTo(m_PointList.GetNext(aPosition));

   pDC->SelectObject(pOldPen);         // Przywr stare piro
}

void CCurve::Move(CSize& aSize)
{
  m_EnclosingRect += aSize;            // Przenie prostokt

  // Pobierz pozycj pierwszego elementu
  POSITION aPosition = m_PointList.GetHeadPosition();

  while(aPosition)
    m_PointList.GetNext(aPosition) += aSize; // Przenie kady punkt z listy
}

void CCurve::Serialize(CArchive& ar)
{
  CElement::Serialize(ar);             // Wywoaj funkcj klasy bazowej.
  m_PointList.Serialize(ar);           // Serializuj list punktw
}

// CText

CText::CText(CPoint Start, CPoint End, CString aString, COLORREF aColor)
{
  m_Pen = 1;                           // Ustawia szeroko pira
  m_Color = aColor;                    // Ustawia kolor tekstu
  m_String = aString;                  // Tworzy kopi acucha
  m_StartPoint = Start;                // Punkt pocztkowy acucha

  m_EnclosingRect = CRect(Start, End);
  m_EnclosingRect.NormalizeRect();
}

void CText::Draw(CDC* pDC, CElement* pElement)
{
  COLORREF Color(m_Color);             // Inicjalizacja z kolorem elementu.

  if(this==pElement)
    Color = SELECT_COLOR;              // Ustawia wybrany kolor

  // Ustawia kolor tekstu i wywietla go
  pDC->SetTextColor(Color);
  pDC->TextOut(m_StartPoint.x, m_StartPoint.y, m_String);
}

void CText::Move(CSize& aSize)
{
  m_StartPoint += aSize;               // Przenie punkt pocztkowy
  m_EnclosingRect += aSize;            // Przenie prostokt
}

void CText::Serialize(CArchive& ar)
{
  CElement::Serialize(ar);             // Wywoaj funkcj klasy bazowej.

  if (ar.IsStoring())
  {
    ar << m_StartPoint                 // Zapisz punkt pocztkowy
       << m_String;                    // i acuch tekstowy.
  }
  else
  {
    ar >> m_StartPoint                 // Pobierz punkt pocztkowy
       >> m_String;                    // i acuch tekstowy.
  }
}
